# Notion Formula Cheatsheet — Creator CRM

## Invoices — Due Date
```
dateAdd(prop("Issued"), toNumber(prop("Net")), "days")
```

## Invoices — Payment Status (Overdue if not paid)
```
if(prop("Status") = "Paid", "Paid",
  if(now() > prop("Due"), "Overdue", prop("Status"))
)
```

## Deals — % Deliverables Complete
(Assumes two rollups on Deals: `Done Count` from Deliverables where Status = "Approved", and `Total Count` for all Deliverables)
```
round(100 * toNumber(prop("Done Count")) / max(1, toNumber(prop("Total Count"))))
```

## Deliverables — Overdue Flag
```
if(empty(prop("Due")), "",
  if(prop("Status") = "Approved", "",
    if(now() > prop("Due"), "Overdue", "")
  )
)
```
